﻿using AZVIC.Ei8htPOS.BAL;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Reports
{
    public partial class LowStockReport : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
           WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindProductList(string.Empty);
            }
        }

        private void BindProductList(string searchWord)
        {
            List<Entities.Products> pcList = ProductsBL.GetList(Guid.Empty, searchWord);
            pcList = (from pb in pcList
                      where (pb.ActualStock + pb.ReserveStock) <= pb.LowStockIndication && pb.IsMiscellaneous == false && pb.IsSales && pb.IsActive
                      orderby pb.ProductName ascending
                      select pb).ToList<Entities.Products>();
            grdProducts.DataSource = pcList;//.OrderBy(reg => reg.SequenceNo);
            grdProducts.DataBind();

            if (pcList.Count == 0)
                WebUtilities.ShowMessage(this, "No Product found");
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindProductList(string.Empty);
            Master.ExportToExcel<Entities.Products>(grdProducts, "LowStockReport");
        }


        protected void grdProducts_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdProducts.PageIndex = e.NewPageIndex;
            BindProductList(txtSearch.Text.Trim());
        }

        protected void grdProducts_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //Label lblCategoryName = e.Row.FindControl("lblCategoryName") as Label;
                //Label lblSubCategoryName = e.Row.FindControl("lblSubCategoryName") as Label;
                Label lblBrandName = e.Row.FindControl("lblBrandName") as Label;
                Label lblColorName = e.Row.FindControl("lblColorName") as Label;
                Label lblSize = e.Row.FindControl("lblSize") as Label;

                Entities.Products curProd = (Entities.Products)e.Row.DataItem;

                //lblCategoryName.Text = ProductCategoryBL.GetItem(curProd.ProductCategoryID, string.Empty).CategoryName;
                //lblSubCategoryName.Text = ((curProd.ProductSubCategoryID != null && curProd.ProductSubCategoryID != Guid.Empty) ? ProductSubCategoryBL.GetItem(curProd.ProductSubCategoryID, Guid.Empty, string.Empty).SubCategoryName : string.Empty);
                lblBrandName.Text = ((curProd.ProductBrandID != null && curProd.ProductBrandID != Guid.Empty) ? ProductBrandBL.GetItem(curProd.ProductBrandID, string.Empty).BrandName : string.Empty);
                lblColorName.Text = ((curProd.ProductColorID != null && curProd.ProductColorID != Guid.Empty) ? ProductColorBL.GetItem(curProd.ProductColorID, string.Empty).ColorName : string.Empty);
                lblSize.Text = ((curProd.ProductMeasurementID != null && curProd.ProductColorID != Guid.Empty) ? ProductMeasurementBL.GetItem(curProd.ProductMeasurementID, string.Empty).MeasurementName : string.Empty);
            }
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtSearch.Text.Trim().Length == 0)
            {
                WebUtilities.ShowMessage(this, "Please enter the search word");
                return;
            }
            BindProductList(txtSearch.Text.Trim());
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindProductList(string.Empty);
        }
    }
}